﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Workflow.Activities.Rules;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.Activities.Rules.Design;
using System.Xml;
using System.IO;


/*  WWF as a Rules Engine 
 
    This example uses the rules engine functionality provided by the WWF.
    It executes a set of rules, stored in a file, against a CRL object.
    The example demonstrates the declarative use of the provided rules engine.
    
    No workflows in this example.
 */
namespace Lessons.Workflows
{
    public partial class MainForm : Form
    {
        RuleSet ruleSet = null;
        Employee employee = new Employee();

        readonly string FileName = Path.GetFullPath(@"..\..\Employee.rules");

        public MainForm()
        {
            InitializeComponent();
        }

        private void btnComputeSalary_Click(object sender, EventArgs e)
        {
            try
            {
                if ((ruleSet == null) && (File.Exists(FileName)))
                    ruleSet = RulesEngine.LoadFromFile(FileName);

                employee.Age = int.Parse(edtAge.Text);
                employee.Rank = chIsManager.Checked ? Rank.Manager : Rank.Clerk;
                employee.Salary = double.Parse(edtInitialSalary.Text);

                RulesEngine.Execute(ruleSet, employee);
                edtSalary.Text = employee.Salary.ToString();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);    
            }        

        }

        private void btnDisplayRulesDialog_Click(object sender, EventArgs e)
        {
            if (File.Exists(FileName))
                ruleSet = RulesEngine.LoadFromFile(FileName);

            if (RulesEngine.DisplayDialog(typeof(Employee), ref ruleSet))
                RulesEngine.SaveToFile(ruleSet, FileName);
        }
    }





 


    [Serializable]
    public enum Rank
    {
        Manager,
        Clerk
    }




    /* a simple class used in demonstrating the rules engine functionality of the WWF */
    public class Employee
    {
        public Employee()
        {
            Age = 30;
            Rank = Rank.Clerk;
            Salary = 1000;
        }

        static double ComputeSalary(Employee Employee)
        {
            double Result = Employee.Salary;

            if (Employee.Rank == Rank.Manager)
                Result += Result * 0.25;

            if (Employee.Age <= 29)
                Result -= Result * 0.10;

            return Result;
        }

        public int Age { get; set; }
        public Rank Rank { get; set; }
        public double Salary { get; set; }
    }




}


 